<?php

namespace App\Filament\Resources;

use App\Filament\Resources\PlayerResource\Pages;
use App\Models\Player;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class PlayerResource extends Resource
{
    protected static ?string $model = Player::class;

    protected static ?string $navigationIcon = 'heroicon-o-users';

    public static function getNavigationLabel(): string
    {
        return __('messages.players');
    }

    public static function getModelLabel(): string
    {
        return __('messages.players');
    }

    public static function getPluralModelLabel(): string
    {
        return __('messages.players');
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Section::make()
                    ->schema([
                        Forms\Components\TextInput::make('api_player_id')
                            ->label(__('معرف اللاعب (API)'))
                            ->numeric()
                            ->default(null),
                        Forms\Components\Select::make('team_id')
                            ->label(__('الفريق'))
                            ->relationship('team', 'name_ar')
                            ->searchable()
                            ->preload()
                            ->required(),
                        Forms\Components\TextInput::make('name_en')
                            ->label(__('الاسم (إنجليزي)'))
                            ->required()
                            ->maxLength(255),
                        Forms\Components\TextInput::make('name_ar')
                            ->label(__('الاسم (عربي)'))
                            ->maxLength(255)
                            ->default(null),
                        Forms\Components\TextInput::make('position')
                            ->label(__('المركز'))
                            ->maxLength(255)
                            ->default(null),
                        Forms\Components\FileUpload::make('photo')
                            ->label(__('الصورة'))
                            ->image()
                            ->disk('public')
                            ->directory('players')
                            ->default(null),
                        Forms\Components\Textarea::make('description_en')
                            ->label(__('الوصف (إنجليزي)'))
                            ->columnSpanFull(),
                        Forms\Components\Textarea::make('description_ar')
                            ->label(__('الوصف (عربي)'))
                            ->columnSpanFull(),
                    ])->columns(2),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\ImageColumn::make('photo')
                    ->label(__('الصورة'))
                    ->circular(),
                Tables\Columns\TextColumn::make('name_ar')
                    ->label(__('الاسم (عربي)'))
                    ->searchable(),
                Tables\Columns\TextColumn::make('name_en')
                    ->label(__('الاسم (إنجليزي)'))
                    ->searchable(),
                Tables\Columns\TextColumn::make('team.name_ar')
                    ->label(__('الفريق'))
                    ->sortable(),
                Tables\Columns\TextColumn::make('position')
                    ->label(__('المركز'))
                    ->searchable(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListPlayers::route('/'),
            'create' => Pages\CreatePlayer::route('/create'),
            'edit' => Pages\EditPlayer::route('/{record}/edit'),
        ];
    }
}
