<?php

namespace App\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use App\Models\FootballMatch;
use Illuminate\Http\Request;

class MatchController extends Controller
{
    public function index(Request $request)
    {
        $status = $request->input('status');
        $leagueId = $request->input('league_id');

        $query = FootballMatch::with('league');

        if ($status) {
            $query->where('status', $status);
        }

        if ($leagueId) {
            $query->where('league_id', $leagueId);
        }

        return response()->json([
            'status' => 'success',
            'data' => $query->latest('match_date')->paginate(20),
        ]);
    }

    public function live()
    {
        $matches = FootballMatch::with('league')
            ->where('status', 'live')
            ->get();

        return response()->json([
            'status' => 'success',
            'data' => $matches,
        ]);
    }

    public function fixtures(Request $request)
    {
        $leagueId = $request->input('league_id');

        $query = FootballMatch::with('league')
            ->where('status', 'scheduled')
            ->where('match_date', '>=', now());

        if ($leagueId) {
            $query->where('league_id', $leagueId);
        }

        return response()->json([
            'status' => 'success',
            'data' => $query->orderBy('match_date', 'asc')->get(),
        ]);
    }

    public function show($id)
    {
        $match = FootballMatch::with('league')->findOrFail($id);

        return response()->json([
            'status' => 'success',
            'data' => $match,
        ]);
    }
}
