<?php

namespace App\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use App\Models\News;
use Illuminate\Http\Request;

class NewsController extends Controller
{
    public function index(Request $request)
    {
        $category = $request->input('category');

        $query = News::where('status', 'published')
            ->orderBy('is_pinned', 'desc')
            ->orderBy('published_at', 'desc');

        if ($category) {
            $query->whereHas('category', function ($q) use ($category) {
                $q->where('slug', $category);
            });
        }

        $news = $query->paginate(15);

        return response()->json([
            'status' => 'success',
            'data' => $news,
        ]);
    }

    public function categories()
    {
        $categories = \App\Models\NewsCategory::all();

        return response()->json([
            'status' => 'success',
            'data' => $categories,
        ]);
    }

    public function show($slug)
    {
        $news = News::where('slug', $slug)
            ->where('status', 'published')
            ->firstOrFail();

        return response()->json([
            'status' => 'success',
            'data' => $news,
        ]);
    }
}
