<?php

namespace App\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use App\Models\Player;
use Illuminate\Http\Request;

class PlayerController extends Controller
{
    public function index(Request $request)
    {
        $search = $request->input('search');
        $teamId = $request->input('team_id');

        $query = Player::query();

        if ($search) {
            $query->where(function ($q) use ($search) {
                $q->where('name_en', 'like', "%{$search}%")
                    ->orWhere('name_ar', 'like', "%{$search}%");
            });
        }

        if ($teamId) {
            $query->where('team_id', $teamId);
        }

        $players = $query->paginate(15);

        return response()->json([
            'status' => 'success',
            'data' => $players,
        ]);
    }

    public function show($id)
    {
        $player = Player::with('team')->findOrFail($id);

        return response()->json([
            'status' => 'success',
            'data' => $player,
        ]);
    }
}
