<?php

namespace App\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use App\Models\Team;
use Illuminate\Http\Request;

class TeamController extends Controller
{
    public function index(Request $request)
    {
        $search = $request->input('search');

        $query = Team::query();

        if ($search) {
            $query->where(function ($q) use ($search) {
                $q->where('name_en', 'like', "%{$search}%")
                    ->orWhere('name_ar', 'like', "%{$search}%");
            });
        }

        $teams = $query->paginate(15);

        return response()->json([
            'status' => 'success',
            'data' => $teams,
        ]);
    }

    public function show($id)
    {
        $team = Team::with('players')->findOrFail($id);

        return response()->json([
            'status' => 'success',
            'data' => $team,
        ]);
    }
}
