<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Favorite extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'item_type',
        'item_id',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function item()
    {
        // Polymorphic relationship manually handled or via morphTo if table structure matches
        // But PRD specifies item_type as enum and item_id as bigint.
        return $this->morphTo(null, 'item_type', 'item_id');
    }
}
