<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FootballMatch extends Model
{
    use HasFactory;

    protected $table = 'matches';

    protected $fillable = [
        'api_fixture_id',
        'league_id',
        'match_date',
        'status',
        'home_team_name_en',
        'home_team_name_ar',
        'home_team_logo',
        'away_team_name_en',
        'away_team_name_ar',
        'away_team_logo',
        'home_score',
        'away_score',
        'venue',
        'city',
        'raw_json',
        'finished_at',
        'live_visible_until',
        'last_status_check_at',
    ];

    protected $casts = [
        'match_date' => 'datetime',
        'raw_json' => 'array',
        'finished_at' => 'datetime',
        'live_visible_until' => 'datetime',
        'last_status_check_at' => 'datetime',
    ];

    public function league()
    {
        return $this->belongsTo(League::class);
    }
}
