<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

class Player extends Model implements HasMedia
{
    use HasFactory, InteractsWithMedia;

    protected $fillable = [
        'api_player_id',
        'team_id',
        'name_en',
        'name_ar',
        'position',
        'photo',
        'description_en',
        'description_ar',
        'stats_json',
    ];

    protected $casts = [
        'stats_json' => 'array',
    ];

    public function team()
    {
        return $this->belongsTo(Team::class);
    }
}
