<?php

require 'vendor/autoload.php';
$app = require_once 'bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use Illuminate\Support\Facades\Http;

$apiKey = config('services.football_api.key');
$response = Http::withHeaders([
    'x-rapidapi-key' => $apiKey,
    'x-rapidapi-host' => 'v3.football.api-sports.io',
])->get('https://v3.football.api-sports.io/leagues', ['id' => 39]);

file_put_contents('league_39_info.json', json_encode($response->json(), JSON_PRETTY_PRINT));
echo "League 39 info saved\n";
