<?php

require 'vendor/autoload.php';
$app = require_once 'bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use Illuminate\Support\Facades\Http;

$apiKey = config('services.football_api.key');
$baseUrl = 'https://v3.football.api-sports.io';

$response = Http::withHeaders([
    'x-rapidapi-key' => $apiKey,
    'x-rapidapi-host' => 'v3.football.api-sports.io',
])->get("{$baseUrl}/leagues", ['id' => 39]);

echo json_encode($response->json(), JSON_PRETTY_PRINT);
