<?php

require 'vendor/autoload.php';
$app = require_once 'bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Services\FootballApiService;

$api = new FootballApiService;
$response = $api->getFixtures([
    'league' => 39,
    'date' => '2026-01-30',
]);

echo 'Fixtures for League 39 on 2026-01-30: '.count($response)."\n";
if (count($response) > 0) {
    echo 'Season used: '.$response[0]['league']['season']."\n";
} else {
    // Try range
    $response = $api->getFixtures([
        'league' => 39,
        'from' => '2026-01-20',
        'to' => '2026-02-10',
    ]);
    echo 'Fixtures for League 39 around this date: '.count($response)."\n";
    if (count($response) > 0) {
        echo 'Season used for first match in range: '.$response[0]['league']['season']."\n";
        echo 'First match date: '.$response[0]['fixture']['date']."\n";
    }
}
