<?php

require 'vendor/autoload.php';
$app = require_once 'bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\League;

$league = League::where('api_league_id', 39)->first();
if ($league) {
    $standings = $league->standings_json;
    if (empty($standings)) {
        echo "Standings: EMPTY\n";
    } else {
        $firstTeam = $standings[0][0] ?? null;
        echo 'League: '.$league->name_en."\n";
        echo 'Season/Group: '.($firstTeam['group'] ?? 'N/A')."\n";
        echo 'First Team: '.($firstTeam['team']['name'] ?? 'N/A')."\n";
        echo 'Played: '.($firstTeam['all']['played'] ?? 'N/A')."\n";
        echo 'Points: '.($firstTeam['points'] ?? 'N/A')."\n";
        echo 'Full JSON (first 500 chars): '.substr(json_encode($standings), 0, 500)."...\n";
    }
} else {
    echo "League 39 not found\n";
}
