<?php

namespace Database\Seeders;

use App\Models\NewsCategory;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class NewsCategorySeeder extends Seeder
{
    public function run(): void
    {
        $categories = [
            ['name_en' => 'International News', 'name_ar' => 'أخبار عالمية'],
            ['name_en' => 'Local News', 'name_ar' => 'أخبار محلية'],
            ['name_en' => 'Transfers', 'name_ar' => 'انتقالات'],
        ];

        foreach ($categories as $category) {
            NewsCategory::updateOrCreate(
                ['slug' => Str::slug($category['name_en'])],
                $category
            );
        }
    }
}
