<?php

namespace Database\Seeders;

use App\Models\Setting;
use Illuminate\Database\Seeder;

class SettingSeeder extends Seeder
{
    public function run(): void
    {
        $settings = [
            ['key' => 'app_name', 'value' => 'ScoreHub'],
            ['key' => 'contact_email', 'value' => 'contact@scorehub.com'],
            ['key' => 'sync_interval', 'value' => '3'],
            ['key' => 'facebook_url', 'value' => 'https://facebook.com/scorehub'],
            ['key' => 'twitter_url', 'value' => 'https://twitter.com/scorehub'],
        ];

        foreach ($settings as $setting) {
            Setting::updateOrCreate(['key' => $setting['key']], $setting);
        }
    }
}
