<?php

require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\FootballMatch;
use App\Models\League;

echo "--- Latest 10 Matches ---\n";
$matches = FootballMatch::orderBy('match_date', 'desc')->take(10)->get();
foreach ($matches as $m) {
    echo "ID: {$m->api_fixture_id} | Date: {$m->match_date} | {$m->home_team_name_en} {$m->home_score}-{$m->away_score} {$m->away_team_name_en} | Status: {$m->status}\n";
}

echo "\n--- Premier League (39) Top 3 Standings ---\n";
$l = League::where('api_league_id', 39)->first();
if ($l && $l->standings_json) {
    $s = $l->standings_json[0] ?? [];
    for ($i = 0; $i < min(3, count($s)); $i++) {
        echo "Rank {$s[$i]['rank']}: {$s[$i]['team']['name']} - Pts: {$s[$i]['points']} - Played: {$s[$i]['all']['played']}\n";
    }
} else {
    echo "No standings for PL.\n";
}

echo "\n--- CAF Champions League (848) Standings Check ---\n";
$caf = League::where('api_league_id', 848)->first();
if ($caf && $caf->standings_json) {
    echo "CAF Standings exist.\n";
    // CAF might have multiple groups
    foreach ($caf->standings_json as $index => $group) {
        echo 'Group '.($index + 1).': '.($group[0]['team']['name'] ?? 'N/A')." is 1st\n";
    }
} else {
    echo "No standings for CAF CL.\n";
}
