class FootballMatch {
  final int id;
  final String homeTeamNameEn;
  final String homeTeamNameAr;
  final String? homeTeamLogo;
  final String awayTeamNameEn;
  final String awayTeamNameAr;
  final String? awayTeamLogo;
  final int? homeScore;
  final int? awayScore;
  final String status;
  final DateTime matchDate;
  final String leagueName;

  FootballMatch({
    required this.id,
    required this.homeTeamNameEn,
    required this.homeTeamNameAr,
    this.homeTeamLogo,
    required this.awayTeamNameEn,
    required this.awayTeamNameAr,
    this.awayTeamLogo,
    this.homeScore,
    this.awayScore,
    required this.status,
    required this.matchDate,
    required this.leagueName,
  });

  factory FootballMatch.fromJson(Map<String, dynamic> json) {
    return FootballMatch(
      id: json['id'],
      homeTeamNameEn: json['home_team_name_en'] ?? '',
      homeTeamNameAr: json['home_team_name_ar'] ?? '',
      homeTeamLogo: json['home_team_logo'],
      awayTeamNameEn: json['away_team_name_en'] ?? '',
      awayTeamNameAr: json['away_team_name_ar'] ?? '',
      awayTeamLogo: json['away_team_logo'],
      homeScore: json['home_score'],
      awayScore: json['away_score'],
      status: json['status'] ?? '',
      matchDate: DateTime.parse(json['match_date']),
      leagueName: json['league'] != null ? json['league']['name_ar'] ?? json['league']['name_en'] : '',
    );
  }
}
