class News {
  final int id;
  final String titleAr;
  final String titleEn;
  final String? coverImage;
  final String contentAr;
  final String contentEn;
  final String slug;
  final DateTime? publishedAt;

  News({
    required this.id,
    required this.titleAr,
    required this.titleEn,
    this.coverImage,
    required this.contentAr,
    required this.contentEn,
    required this.slug,
    this.publishedAt,
  });

  factory News.fromJson(Map<String, dynamic> json) {
    return News(
      id: json['id'],
      titleAr: json['title_ar'] ?? '',
      titleEn: json['title_en'] ?? '',
      coverImage: json['cover_image'],
      contentAr: json['content_ar'] ?? '',
      contentEn: json['content_en'] ?? '',
      slug: json['slug'] ?? '',
      publishedAt: json['published_at'] != null ? DateTime.parse(json['published_at']) : null,
    );
  }
}
