@extends('layouts.app')

@section('title', $match->home_team_name_en . ' vs ' . $match->away_team_name_en)

@section('content')
<style>
    .glass-card { background: rgba(30, 41, 59, 0.7); backdrop-filter: blur(10px); border: 1px solid rgba(255, 255, 255, 0.05); }
    .score-box { background: linear-gradient(145deg, #1e293b, #0f172a); border: 1px solid #334155; }
</style>

<div class="max-w-4xl mx-auto py-8">
    <!-- Navigation -->
    <div class="flex justify-between items-center mb-8">
        <a href="{{ url('/') }}" class="flex items-center gap-2 px-4 py-2 bg-slate-800 hover:bg-slate-700 rounded-xl transition border border-slate-700">
            <i class="fas fa-chevron-{{ app()->getLocale() == 'ar' ? 'left' : 'right' }}"></i>
            <span>{{ __('messages.back_to_home') }}</span>
        </a>
        <div class="text-slate-500 font-bold uppercase tracking-widest text-xs">
            {{ __('messages.match_details') }}
        </div>
    </div>

    <!-- Match Header Card -->
    <div class="glass-card rounded-[3rem] p-8 md:p-12 shadow-2xl overflow-hidden relative">
        <!-- Background Decoration -->
        <div class="absolute top-0 left-0 w-full h-1 bg-gradient-to-r from-blue-500 via-purple-500 to-pink-500"></div>
        
        <!-- League Info -->
        <div class="text-center mb-10">
            <span class="px-4 py-1.5 rounded-full bg-blue-500/10 text-blue-400 text-xs font-black uppercase tracking-tighter border border-blue-500/20">
                {{ $match->league->name_en ?? 'Football' }}
            </span>
            <div class="mt-4 text-slate-400 text-sm">
                {{ $match->match_date->format('d M Y - H:i') }}
            </div>
        </div>

        <!-- Scoreboard -->
        <div class="flex flex-col md:flex-row items-center justify-between gap-8 md:gap-4">
            <!-- Home Team -->
            <div class="flex flex-col items-center flex-1 order-2 md:order-1">
                <div class="relative group">
                    <div class="absolute -inset-4 bg-blue-500/20 rounded-full blur-2xl group-hover:bg-blue-500/40 transition duration-500"></div>
                    <img src="{{ Str::startsWith($match->home_team_logo, 'http') ? $match->home_team_logo : asset('storage/' . $match->home_team_logo) }}" 
                         class="relative h-24 w-24 md:h-32 md:w-32 object-contain drop-shadow-2xl"
                         onerror="this.src='https://cdn-icons-png.flaticon.com/512/53/53254.png'">
                </div>
                <h2 class="mt-6 text-xl md:text-2xl font-black text-center">{{ $match->home_team_name_en }}</h2>
            </div>

            <!-- Score/Status -->
            <div class="flex flex-col items-center order-1 md:order-2">
                <div class="score-box rounded-3xl px-8 py-4 flex gap-6 items-center shadow-inner">
                    <span class="text-5xl md:text-7xl font-black text-white">{{ $match->home_score ?? 0 }}</span>
                    <span class="text-3xl text-slate-700 font-bold">:</span>
                    <span class="text-5xl md:text-7xl font-black text-white">{{ $match->away_score ?? 0 }}</span>
                </div>
                <div class="mt-6">
                    @if($match->status == 'FT')
                        <span class="bg-slate-900 text-slate-400 px-4 py-1.5 rounded-full text-xs font-black border border-slate-800">{{ __('messages.finished') }}</span>
                    @elseif(is_numeric($match->status))
                        <span class="bg-red-500/10 text-red-500 px-4 py-1.5 rounded-full text-xs font-black animate-pulse border border-red-500/20">
                            {{ __('messages.live') }} {{ $match->status }}'
                        </span>
                    @else
                        <span class="bg-blue-500/10 text-blue-500 px-4 py-1.5 rounded-full text-xs font-black border border-blue-500/20">
                            @php
                                $statusKey = strtolower($match->status);
                                $translatedStatus = __('messages.' . $statusKey);
                            @endphp
                            {{ $translatedStatus !== 'messages.' . $statusKey ? $translatedStatus : $match->status }}
                        </span>
                    @endif
                </div>
            </div>

            <!-- Away Team -->
            <div class="flex flex-col items-center flex-1 order-3">
                <div class="relative group">
                    <div class="absolute -inset-4 bg-emerald-500/20 rounded-full blur-2xl group-hover:bg-emerald-500/40 transition duration-500"></div>
                    <img src="{{ Str::startsWith($match->away_team_logo, 'http') ? $match->away_team_logo : asset('storage/' . $match->away_team_logo) }}" 
                         class="relative h-24 w-24 md:h-32 md:w-32 object-contain drop-shadow-2xl"
                         onerror="this.src='https://cdn-icons-png.flaticon.com/512/53/53254.png'">
                </div>
                <h2 class="mt-6 text-xl md:text-2xl font-black text-center">{{ $match->away_team_name_en }}</h2>
            </div>
        </div>
    </div>

    <!-- Details Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-8">
        <!-- Venue & Status -->
        <div class="space-y-6">
            <div class="glass-card rounded-3xl p-6">
                <h3 class="text-slate-500 text-xs font-black uppercase tracking-widest mb-4 flex items-center gap-2">
                    <i class="fas fa-map-marker-alt text-blue-500"></i>
                    {{ __('messages.venue_info') }}
                </h3>
                <div class="text-lg font-bold">{{ $match->venue ?? 'N/A' }}</div>
                <div class="text-slate-400 text-sm">{{ $match->city ?? 'N/A' }}</div>
            </div>

            <div class="glass-card rounded-3xl p-6">
                <h3 class="text-slate-500 text-xs font-black uppercase tracking-widest mb-4 flex items-center gap-2">
                    <i class="fas fa-info-circle text-blue-500"></i>
                    {{ __('messages.match_status') }}
                </h3>
                <div class="text-lg font-bold">
                    @if($match->status == 'FT')
                        {{ __('messages.full_time_result') }}
                    @elseif($match->status == 'NS')
                        {{ __('messages.not_started') }}
                    @else
                        {{ __('messages.in_progress') }}
                    @endif
                </div>
                <div class="text-slate-400 text-sm">{{ __('messages.fixture_id') }}: {{ $match->api_fixture_id }}</div>
            </div>
        </div>

        <!-- Events -->
        <div class="glass-card rounded-3xl p-6 h-full">
            <h3 class="text-slate-500 text-xs font-black uppercase tracking-widest mb-6 flex items-center gap-2">
                <i class="fas fa-bolt text-amber-500"></i>
                {{ __('messages.match_events') }}
            </h3>
            
            @if(isset($match->raw_json['events']) && count($match->raw_json['events']) > 0)
                <div class="space-y-4 relative">
                    <div class="absolute {{ app()->getLocale() == 'ar' ? 'left-[11px]' : 'right-[11px]' }} top-0 bottom-0 w-0.5 bg-slate-800"></div>
                    @foreach($match->raw_json['events'] as $event)
                        <div class="flex items-start gap-4 relative">
                            <div class="z-10 bg-slate-900 border-2 {{ $event['type'] == 'Goal' ? 'border-emerald-500' : ($event['type'] == 'Card' ? 'border-amber-500' : 'border-blue-500') }} rounded-full p-1 text-[10px] w-6 h-6 flex items-center justify-center font-bold">
                                {{ $event['time']['elapsed'] }}
                            </div>
                            <div class="flex-1">
                                <div class="text-sm font-bold">
                                    {{ $event['player']['name'] }}
                                    @if($event['type'] == 'Goal')
                                        <i class="fas fa-futbol text-emerald-500 {{ app()->getLocale() == 'ar' ? 'mr-1' : 'ml-1' }}"></i>
                                    @elseif($event['type'] == 'Card')
                                        <i class="fas fa-square {{ $event['detail'] == 'Yellow Card' ? 'text-amber-500' : 'text-red-500' }} {{ app()->getLocale() == 'ar' ? 'mr-1' : 'ml-1' }}"></i>
                                    @endif
                                </div>
                                <div class="text-xs text-slate-500">
                                    {{ $event['team']['name'] }} • {{ $event['detail'] }}
                                    @if(isset($event['assist']['name']))
                                        <span class="opacity-50">• {{ __('messages.assist') }}: {{ $event['assist']['name'] }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="flex flex-col items-center justify-center h-48 text-slate-600">
                    <i class="fas fa-history text-3xl mb-3 opacity-20"></i>
                    <p class="text-xs font-bold">{{ __('messages.no_events') }}</p>
                </div>
            @endif
        </div>
    </div>

    <!-- Lineups -->
    @if(isset($match->raw_json['lineups']) && count($match->raw_json['lineups']) > 0)
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-6">
            @foreach($match->raw_json['lineups'] as $lineup)
                <div class="glass-card rounded-3xl p-6">
                    <div class="flex justify-between items-center mb-6">
                        <h3 class="font-black text-sm uppercase tracking-widest">{{ $lineup['team']['name'] }}</h3>
                        <span class="text-xs font-bold text-blue-400 bg-blue-400/10 px-3 py-1 rounded-full border border-blue-400/20">{{ $lineup['formation'] }}</span>
                    </div>
                    
                    <div class="space-y-3">
                        <div class="text-[10px] font-black text-slate-500 uppercase mb-2">{{ __('messages.starting_xi') }}</div>
                        @foreach($lineup['startXI'] as $player)
                            <div class="flex items-center justify-between text-sm p-2 rounded-xl hover:bg-white/5 transition">
                                <div class="flex items-center gap-3">
                                    <span class="w-5 text-xs font-bold text-slate-600">{{ $player['player']['number'] }}</span>
                                    <span class="font-bold">{{ $player['player']['name'] }}</span>
                                </div>
                                <span class="text-[10px] text-slate-500 font-bold uppercase">{{ $player['player']['pos'] }}</span>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endforeach
        </div>
    @endif
</div>
@endsection
