@extends('layouts.app')

@section('title', __('messages.match_schedule'))

@section('content')
<style>
    .match-card { background: rgba(30, 41, 59, 0.4); border: 1px solid rgba(255, 255, 255, 0.05); }
    .league-header { background: linear-gradient(to {{ app()->getLocale() == 'ar' ? 'left' : 'right' }}, #1e293b, transparent); }
</style>

<div class="max-w-5xl mx-auto py-8">
    <!-- Header -->
    <div class="flex flex-col md:flex-row justify-between items-center mb-12 gap-6">
        <div>
            <h1 class="text-3xl font-black mb-2">{{ __('messages.match_schedule') }}</h1>
            <p class="text-slate-400">{{ __('messages.follow_results') }}</p>
        </div>
        
        <div class="flex items-center gap-4 bg-slate-800/50 p-2 rounded-2xl border border-slate-700">
            <a href="{{ route('matches.index', ['date' => \Carbon\Carbon::parse($date)->subDay()->toDateString()]) }}" 
               class="p-2 hover:bg-slate-700 rounded-xl transition">
                <i class="fas fa-chevron-{{ app()->getLocale() == 'ar' ? 'right' : 'left' }}"></i>
            </a>
            <div class="flex flex-col items-center px-4">
                <span class="text-xs text-blue-400 font-bold uppercase tracking-tighter">{{ \Carbon\Carbon::parse($date)->translatedFormat('D, d M') }}</span>
                <input type="date" value="{{ $date }}" onchange="window.location.href='{{ route('matches.index') }}?date=' + this.value"
                       class="bg-transparent text-sm font-bold focus:outline-none cursor-pointer">
            </div>
            <a href="{{ route('matches.index', ['date' => \Carbon\Carbon::parse($date)->addDay()->toDateString()]) }}" 
               class="p-2 hover:bg-slate-700 rounded-xl transition">
                <i class="fas fa-chevron-{{ app()->getLocale() == 'ar' ? 'left' : 'right' }}"></i>
            </a>
        </div>
    </div>

    @php
        $locale = app()->getLocale();
        // Group by league_id but keep the original order from the controller
        $groupedMatches = $matches->groupBy('league_id');
    @endphp

    @if($matches->count() > 0)
        <div class="space-y-12">
            @foreach($groupedMatches as $leagueId => $leagueMatches)
                @php
                    $firstMatch = $leagueMatches->first();
                    $leagueName = $firstMatch->league->{'name_'.$locale} ?: $firstMatch->league->name_en ?: __('messages.other_leagues');
                @endphp
                <div>
                    <div class="league-header p-4 rounded-xl mb-4 border-{{ $locale == 'ar' ? 'r' : 'l' }}-4 border-blue-500">
                        <h2 class="text-lg font-black flex items-center gap-3">
                            <i class="fas fa-trophy text-amber-500"></i>
                            {{ $leagueName }}
                        </h2>
                    </div>

                    <div class="grid gap-3">
                        @foreach($leagueMatches as $match)
                            <a href="{{ route('match.show', $match->id) }}" 
                               class="match-card group p-4 rounded-2xl flex items-center justify-between hover:bg-slate-800/60 transition duration-300">
                                
                                <!-- Time/Status -->
                                <div class="w-20 text-center">
                                    @if($match->status == 'FT')
                                        <span class="text-xs font-bold text-slate-500">FT</span>
                                    @elseif($match->status == 'NS')
                                        <span class="text-sm font-black text-blue-400">{{ $match->match_date->format('H:i') }}</span>
                                    @else
                                        <span class="text-xs font-black text-red-500 animate-pulse">{{ $match->status }}'</span>
                                    @endif
                                </div>

                                <!-- Teams -->
                                <div class="flex-1 flex items-center justify-center gap-4 md:gap-12">
                                    <div class="flex items-center gap-3 flex-1 justify-end">
                                        <span class="font-bold text-sm md:text-base text-right">{{ $match->{'home_team_name_'.$locale} ?: $match->home_team_name_en }}</span>
                                        <img src="{{ Str::startsWith($match->home_team_logo, 'http') ? $match->home_team_logo : asset('storage/' . $match->home_team_logo) }}" 
                                             class="h-8 w-8 object-contain"
                                             onerror="this.src='https://cdn-icons-png.flaticon.com/512/53/53254.png'">
                                    </div>

                                    <div class="bg-slate-900/80 px-4 py-1.5 rounded-xl font-black text-lg min-w-[80px] text-center">
                                        @if($match->status == 'NS')
                                            <span class="text-slate-600">VS</span>
                                        @else
                                            <span class="text-white">{{ $match->home_score }} - {{ $match->away_score }}</span>
                                        @endif
                                    </div>

                                    <div class="flex items-center gap-3 flex-1">
                                        <img src="{{ Str::startsWith($match->away_team_logo, 'http') ? $match->away_team_logo : asset('storage/' . $match->away_team_logo) }}" 
                                             class="h-8 w-8 object-contain"
                                             onerror="this.src='https://cdn-icons-png.flaticon.com/512/53/53254.png'">
                                        <span class="font-bold text-sm md:text-base">{{ $match->{'away_team_name_'.$locale} ?: $match->away_team_name_en }}</span>
                                    </div>
                                </div>

                                <!-- Action -->
                                <div class="w-10 flex justify-end">
                                    <i class="fas fa-chevron-{{ $locale == 'ar' ? 'left' : 'right' }} text-slate-700 group-hover:text-blue-500 transition"></i>
                                </div>
                            </a>
                        @endforeach
                    </div>
                </div>
            @endforeach
        </div>
    @else
        <div class="bg-slate-800/20 rounded-3xl p-20 text-center border border-dashed border-slate-700">
            <i class="far fa-calendar-times text-5xl text-slate-700 mb-4"></i>
            <p class="text-slate-500 font-bold">{{ __('messages.no_matches_scheduled') }}</p>
        </div>
    @endif
</div>
@endsection
