@extends('layouts.app')

@section('title', __('messages.home'))

@section('content')
    <!-- Results Ticker -->
    @php
        $locale = app()->getLocale();
    @endphp

    <div x-data="{ activeTab: 'today' }" class="mb-12 bg-[#1a1a1a] border-b border-white/5 shadow-2xl overflow-hidden rounded-b-[2rem]">
        <!-- Ticker Header -->
        <div class="flex items-center justify-between px-8 py-4 bg-black/20">
            <div class="flex items-center gap-8">
                <h2 class="text-lg font-black text-white flex items-center gap-3">
                    <i class="fas fa-calendar-alt text-blue-500"></i>
                    {{ __('messages.matches') }}
                </h2>
                
                <div class="flex gap-4">
                    <button @click="activeTab = 'live'" :class="activeTab === 'live' ? 'text-blue-500 border-b-2 border-blue-500' : 'text-gray-500 hover:text-white'" class="pb-1 text-sm font-bold transition">{{ __('messages.live') }}</button>
                    <button @click="activeTab = 'today'" :class="activeTab === 'today' ? 'text-blue-500 border-b-2 border-blue-500' : 'text-gray-500 hover:text-white'" class="pb-1 text-sm font-bold transition">{{ __('messages.today') }}</button>
                    <button @click="activeTab = 'yesterday'" :class="activeTab === 'yesterday' ? 'text-blue-500 border-b-2 border-blue-500' : 'text-gray-500 hover:text-white'" class="pb-1 text-sm font-bold transition">{{ __('messages.yesterday') }}</button>
                </div>
            </div>
            <a href="{{ route('matches.index') }}" class="text-xs font-bold text-blue-400 hover:text-white transition">{{ __('messages.view_all') }}</a>
        </div>

        <!-- Ticker Container -->
        <div class="relative group">
            <button onclick="document.getElementById('ticker-results').scrollBy({left: -400, behavior: 'smooth'})" 
                    class="absolute right-0 top-0 bottom-0 z-10 bg-black/40 hover:bg-blue-600 px-4 text-white transition flex items-center">
                <i class="fas fa-chevron-right"></i>
            </button>
            <button onclick="document.getElementById('ticker-results').scrollBy({left: 400, behavior: 'smooth'})" 
                    class="absolute left-0 top-0 bottom-0 z-10 bg-black/40 hover:bg-blue-600 px-4 text-white transition flex items-center">
                <i class="fas fa-chevron-left"></i>
            </button>

            <div id="ticker-results" class="overflow-x-auto no-scrollbar scroll-smooth py-8">
                <!-- Live Tab Content -->
                <div x-show="activeTab === 'live'" class="flex flex-nowrap min-w-max px-12 gap-6">
                    @forelse($liveMatches as $match)
                        @include('partials.match-card-ticker', ['match' => $match])
                    @empty
                        <div class="text-gray-500 font-bold py-4">{{ __('messages.no_live_matches') }}</div>
                    @endforelse
                </div>

                <!-- Today Tab Content -->
                <div x-show="activeTab === 'today'" class="flex flex-nowrap min-w-max px-12 gap-6">
                    @forelse($todayMatches as $match)
                        @include('partials.match-card-ticker', ['match' => $match])
                    @empty
                        <div class="text-gray-500 font-bold py-4">{{ __('messages.no_matches_today') }}</div>
                    @endforelse
                </div>

                <!-- Yesterday Tab Content -->
                <div x-show="activeTab === 'yesterday'" class="flex flex-nowrap min-w-max px-12 gap-6">
                    @forelse($yesterdayMatches as $match)
                        @include('partials.match-card-ticker', ['match' => $match])
                    @empty
                        <div class="text-gray-500 font-bold py-4">{{ __('messages.no_matches_yesterday') }}</div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>
    
    <style>
        .no-scrollbar::-webkit-scrollbar { display: none; }
        .no-scrollbar { -ms-overflow-style: none; scrollbar-width: none; }
    </style>

    <!-- Live Matches Section -->
    <section id="matches" class="mb-12">
        <div class="flex justify-between items-center mb-8">
            <h2 class="text-2xl font-black flex items-center gap-3">
                <span class="flex h-3 w-3 relative">
                    <span class="animate-ping absolute inline-flex h-full w-full rounded-full bg-red-400 opacity-75"></span>
                    <span class="relative inline-flex rounded-full h-3 w-3 bg-red-600"></span>
                </span>
                {{ __('messages.live_matches') }}
            </h2>
        </div>
        
        @if($liveMatches->count() > 0)
            <div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-6">
                @foreach($liveMatches as $match)
                    <a href="{{ route('match.show', $match->id) }}" class="group relative bg-slate-800/40 border border-white/5 rounded-3xl p-6 hover:bg-slate-800/60 transition duration-300 block">
                        <!-- Match Header -->
                        <div class="flex justify-between items-center mb-6 text-[11px] font-bold text-slate-500 uppercase tracking-widest">
                            <span>{{ $match->league->name_en }}</span>
                            <span class="text-red-500 animate-pulse">{{ $match->status }}'</span>
                        </div>

                        <!-- Teams and Score -->
                        <div class="flex items-center justify-between gap-4">
                            <!-- Home Team -->
                            <div class="flex flex-col items-center flex-1 text-center">
                                <img src="{{ Str::startsWith($match->home_team_logo, 'http') ? $match->home_team_logo : asset('storage/' . $match->home_team_logo) }}" 
                                     class="h-16 w-16 object-contain mb-3 drop-shadow-2xl group-hover:scale-110 transition duration-300">
                                <span class="font-bold text-sm leading-tight h-10 flex items-center">{{ $match->home_team_name_en }}</span>
                            </div>

                            <!-- Live Score -->
                            <div class="flex flex-col items-center">
                                <div class="bg-slate-900/80 rounded-2xl px-4 py-2 flex gap-4 text-3xl font-black text-white shadow-inner">
                                    <span class="text-blue-400">{{ $match->home_score }}</span>
                                    <span class="text-slate-700">:</span>
                                    <span class="text-blue-400">{{ $match->away_score }}</span>
                                </div>
                                <div class="mt-3 text-[10px] bg-red-600/10 text-red-500 px-3 py-1 rounded-full font-black uppercase tracking-tighter">
                                    {{ __('messages.live_now') }}
                                </div>
                            </div>

                            <!-- Away Team -->
                            <div class="flex flex-col items-center flex-1 text-center">
                                <img src="{{ Str::startsWith($match->away_team_logo, 'http') ? $match->away_team_logo : asset('storage/' . $match->away_team_logo) }}" 
                                     class="h-16 w-16 object-contain mb-3 drop-shadow-2xl group-hover:scale-110 transition duration-300">
                                <span class="font-bold text-sm leading-tight h-10 flex items-center">{{ $match->away_team_name_en }}</span>
                            </div>
                        </div>

                        <!-- Match Footer Decor -->
                        <div class="absolute bottom-0 left-1/2 -translate-x-1/2 w-1/2 h-0.5 bg-gradient-to-r from-transparent via-blue-500/50 to-transparent"></div>
                    </a>
                @endforeach
            </div>
        @else
            <div class="relative overflow-hidden bg-slate-800/20 border border-white/5 rounded-3xl p-12 text-center group">
                <div class="absolute inset-0 bg-gradient-to-r from-transparent via-white/5 to-transparent -translate-x-full group-hover:translate-x-full transition duration-1000"></div>
                <div class="relative">
                    <i class="fas fa-satellite-dish text-5xl text-slate-700 mb-4"></i>
                    <p class="text-slate-500 font-bold">{{ __('messages.no_live_matches') }}</p>
                    <p class="text-xs text-slate-600 mt-2 italic">{{ __('messages.auto_update_msg') }}</p>
                </div>
            </div>
        @endif
    </section>

    <!-- Standings Snapshot -->
    <section class="mb-16">
        <h2 class="text-2xl font-black mb-8 flex items-center gap-3">
            <i class="fas fa-list-ol text-blue-500"></i>
            {{ __('messages.standings_table') }}
        </h2>
        
        <div x-data="{ activeStanding: {{ $standingsLeagues->first()->api_league_id ?? 0 }} }">
            <div class="flex gap-4 mb-6 overflow-x-auto no-scrollbar pb-2">
                @foreach($standingsLeagues as $league)
                    <button @click="activeStanding = {{ $league->api_league_id }}" 
                            :class="activeStanding === {{ $league->api_league_id }} ? 'bg-blue-600 text-white' : 'bg-slate-800/40 text-slate-400 hover:bg-slate-700'"
                            class="px-6 py-2.5 rounded-xl font-bold transition text-sm whitespace-nowrap">
                        {{ $league->{'name_'.$locale} ?: $league->name_en }}
                    </button>
                @endforeach
            </div>

            @foreach($standingsLeagues as $league)
                <div x-show="activeStanding === {{ $league->api_league_id }}" class="bg-slate-900/40 border border-white/5 rounded-3xl overflow-hidden shadow-2xl">
                    <table class="w-full text-center text-sm">
                        <thead>
                            <tr class="bg-white/5 text-slate-500 uppercase text-[10px] font-black tracking-widest border-b border-white/5">
                                <th class="px-4 py-4 w-12">#</th>
                                <th class="px-4 py-4 text-{{ $locale == 'ar' ? 'right' : 'left' }}">{{ __('messages.team') }}</th>
                                <th class="px-4 py-4 w-12">PL</th>
                                <th class="px-4 py-4 w-12 text-blue-400">PTS</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-white/5">
                            @php
                                $standings = is_array($league->standings_json) ? ($league->standings_json[0] ?? []) : [];
                                $topTeams = array_slice($standings, 0, 5);
                            @endphp
                            @foreach($topTeams as $row)
                                <tr class="hover:bg-white/5 transition">
                                    <td class="px-4 py-3 font-black text-slate-500">{{ $row['rank'] }}</td>
                                    <td class="px-4 py-3">
                                        <div class="flex items-center gap-3 text-{{ $locale == 'ar' ? 'right' : 'left' }}">
                                            <img src="{{ $row['team']['logo'] }}" class="h-6 w-6 object-contain">
                                            <span class="font-bold text-slate-200">{{ $row['team']['name'] }}</span>
                                        </div>
                                    </td>
                                    <td class="px-4 py-3 text-slate-400">{{ $row['all']['played'] }}</td>
                                    <td class="px-4 py-3 font-black text-white">{{ $row['points'] }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <div class="p-4 bg-white/5 text-center">
                        <a href="{{ url('/league/' . $league->id) }}" class="text-xs font-bold text-blue-400 hover:text-blue-300 transition flex items-center justify-center gap-2">
                            {{ __('messages.view_all') }}
                            <i class="fas fa-chevron-{{ $locale == 'ar' ? 'left' : 'right' }}"></i>
                        </a>
                    </div>
                </div>
            @endforeach
        </div>
    </section>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-12">
        <!-- Latest News -->
        <div class="lg:col-span-2">
            <section id="news">
                <div class="flex justify-between items-center mb-6">
                    <h2 class="text-2xl font-bold">{{ __('messages.latest_news') }}</h2>
                    <a href="{{ route('news.index') }}" class="text-xs font-bold text-blue-400 hover:text-white transition">{{ __('messages.view_all') }}</a>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    @foreach($latestNews as $item)
                        <a href="{{ route('news.show', $item->slug) }}" class="bg-slate-900/40 border border-white/5 rounded-3xl overflow-hidden shadow-2xl hover:shadow-blue-500/10 transition group block">
                            <img src="{{ $item->image_url }}" class="w-full h-56 object-cover group-hover:scale-105 transition duration-500">
                            <div class="p-6">
                                <div class="text-[10px] text-blue-400 font-black uppercase tracking-widest mb-3">{{ $item->category->{'name_'.$locale} ?? __('messages.general') }}</div>
                                <h3 class="font-bold text-xl mb-3 leading-tight h-14 overflow-hidden text-white group-hover:text-blue-400 transition">{{ $item->{'title_'.$locale} }}</h3>
                                <p class="text-slate-400 text-sm line-clamp-3 mb-6">{{ Str::limit(strip_tags($item->{'content_'.$locale}), 100) }}</p>
                                <div class="flex justify-between items-center">
                                    <div class="text-slate-500 text-[10px] font-bold">{{ $item->published_at ? $item->published_at->diffForHumans() : $item->created_at->diffForHumans() }}</div>
                                    <i class="fas fa-arrow-{{ $locale == 'ar' ? 'left' : 'right' }} text-blue-500 group-hover:{{ $locale == 'ar' ? '-' : '' }}translate-x-2 transition"></i>
                                </div>
                            </div>
                        </a>
                    @endforeach
                </div>
            </section>
        </div>

        <!-- Upcoming & Leagues Sidebar -->
        <div class="space-y-12">
            <section>
                <h2 class="text-xl font-bold mb-6">{{ __('messages.upcoming_matches') }}</h2>
                <div class="space-y-4">
                    @foreach($upcomingMatches as $match)
                        <div class="bg-slate-900/40 border border-white/5 p-4 rounded-2xl">
                            <div class="text-[10px] text-blue-400 font-bold mb-2 uppercase tracking-tighter">{{ $match->match_date->format('Y-m-d H:i') }}</div>
                            <div class="flex justify-between items-center text-sm">
                                <span class="font-bold text-white">{{ $match->{'home_team_name_'.$locale} ?: $match->home_team_name_en }}</span>
                                <span class="text-slate-600 text-xs font-black mx-2">VS</span>
                                <span class="font-bold text-white">{{ $match->{'away_team_name_'.$locale} ?: $match->away_team_name_en }}</span>
                            </div>
                        </div>
                    @endforeach
                </div>
            </section>

            <section>
                <h2 class="text-xl font-bold mb-6">{{ __('messages.leagues') }}</h2>
                <div class="bg-slate-900/40 border border-white/5 rounded-3xl overflow-hidden">
                    @foreach($leagues as $league)
                        <a href="{{ url('/league/' . $league->id) }}" class="px-5 py-4 border-b border-white/5 last:border-0 hover:bg-white/5 transition flex items-center group">
                            <i class="fas fa-trophy text-amber-500 mr-3 ml-3 group-hover:scale-110 transition"></i>
                            <span class="font-bold text-slate-300 group-hover:text-white">{{ $league->{'name_'.$locale} ?: $league->name_en }}</span>
                            <i class="fas fa-chevron-left mr-auto text-slate-700 group-hover:text-blue-500 transition"></i>
                        </a>
                    @endforeach
                </div>
            </section>
        </div>
    </div>
@endsection
