@extends('layouts.app')

@section('title', $news->{'title_'.app()->getLocale()})

@section('content')
<div class="max-w-4xl mx-auto">
    <nav class="flex mb-8 text-sm font-bold text-slate-500 uppercase tracking-widest" aria-label="Breadcrumb">
        <ol class="flex items-center space-x-4 rtl:space-x-reverse">
            <li><a href="{{ route('home') }}" class="hover:text-blue-400">{{ __('messages.home') }}</a></li>
            <li><i class="fas fa-{{ app()->getLocale() == 'ar' ? 'chevron-left' : 'chevron-right' }} text-[10px]"></i></li>
            <li><a href="{{ route('news.index') }}" class="hover:text-blue-400">{{ __('messages.news') }}</a></li>
            <li><i class="fas fa-{{ app()->getLocale() == 'ar' ? 'chevron-left' : 'chevron-right' }} text-[10px]"></i></li>
            <li class="text-blue-400 truncate max-w-[200px]">{{ $news->{'title_'.app()->getLocale()} }}</li>
        </ol>
    </nav>

    <article class="bg-slate-900/40 border border-white/5 rounded-[2.5rem] overflow-hidden shadow-2xl mb-12">
        <div class="relative h-[400px] md:h-[500px]">
            <img src="{{ $news->image_url }}" 
                 class="w-full h-full object-cover" 
                 alt="{{ $news->{'title_'.app()->getLocale()} }}">
            <div class="absolute inset-0 bg-gradient-to-t from-slate-900 via-slate-900/20 to-transparent"></div>
            
            <div class="absolute bottom-0 left-0 right-0 p-8 md:p-12">
                <div class="flex items-center gap-4 mb-6">
                    <span class="bg-blue-600 text-white text-[10px] font-black px-4 py-1.5 rounded-full uppercase tracking-widest shadow-lg">
                        {{ $news->category->{'name_'.app()->getLocale()} }}
                    </span>
                    <span class="text-slate-300 text-xs font-bold flex items-center gap-2">
                        <i class="far fa-calendar-alt text-blue-500"></i>
                        {{ $news->published_at ? $news->published_at->format('Y-m-d') : $news->created_at->format('Y-m-d') }}
                    </span>
                </div>
                <h1 class="text-3xl md:text-5xl font-black text-white leading-tight">
                    {{ $news->{'title_'.app()->getLocale()} }}
                </h1>
            </div>
        </div>

        <div class="p-8 md:p-12">
            <div class="prose prose-invert prose-blue max-w-none text-slate-300 leading-relaxed text-lg">
                {!! Str::markdown($news->{'content_'.app()->getLocale()}) !!}
            </div>

            <div class="mt-12 pt-8 border-t border-white/5 flex flex-wrap gap-4 items-center justify-between">
                <div class="flex items-center gap-3">
                    <div class="h-10 w-10 rounded-full bg-blue-600 flex items-center justify-center font-black text-white">
                        S
                    </div>
                    <div>
                        <div class="text-white font-bold text-sm">ScoreHub Editor</div>
                        <div class="text-slate-500 text-[10px] font-bold uppercase tracking-widest">{{ __('messages.editorial_team') }}</div>
                    </div>
                </div>

                <div class="flex gap-2">
                    <button class="h-10 w-10 rounded-xl bg-white/5 hover:bg-blue-600 transition flex items-center justify-center text-slate-400 hover:text-white">
                        <i class="fab fa-facebook-f"></i>
                    </button>
                    <button class="h-10 w-10 rounded-xl bg-white/5 hover:bg-blue-400 transition flex items-center justify-center text-slate-400 hover:text-white">
                        <i class="fab fa-twitter"></i>
                    </button>
                    <button class="h-10 w-10 rounded-xl bg-white/5 hover:bg-green-600 transition flex items-center justify-center text-slate-400 hover:text-white">
                        <i class="fab fa-whatsapp"></i>
                    </button>
                </div>
            </div>
        </div>
    </article>

    @if($relatedNews->count() > 0)
        <section class="mb-12">
            <h2 class="text-2xl font-black mb-8 flex items-center gap-3">
                <i class="fas fa-layer-group text-blue-500"></i>
                {{ __('messages.related_news') }}
            </h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                @foreach($relatedNews as $item)
                    <a href="{{ route('news.show', $item->slug) }}" class="group bg-slate-900/40 border border-white/5 rounded-3xl overflow-hidden hover:shadow-blue-500/10 transition">
                        <img src="{{ $item->image_url }}" class="w-full h-40 object-cover group-hover:scale-105 transition duration-500">
                        <div class="p-6">
                            <h3 class="font-bold text-white text-sm leading-tight h-10 overflow-hidden group-hover:text-blue-400 transition">
                                {{ $item->{'title_'.app()->getLocale()} }}
                            </h3>
                        </div>
                    </a>
                @endforeach
            </div>
        </section>
    @endif
</div>

<style>
    .prose p { margin-bottom: 1.5rem; }
    .prose h2 { font-size: 1.5rem; font-weight: 800; margin-top: 2rem; margin-bottom: 1rem; color: white; }
    .prose ul { list-style-type: disc; margin-left: 1.5rem; margin-bottom: 1.5rem; }
</style>
@endsection
