<a href="{{ route('match.show', $match->id) }}" class="inline-block w-[300px] bg-white/5 rounded-3xl p-6 border border-white/5 hover:border-blue-500/50 transition duration-300">
    <div class="text-[10px] font-bold text-blue-400 text-center mb-4 uppercase tracking-widest">
        {{ $match->league->{'name_'.app()->getLocale()} ?: $match->league->name_en }}
    </div>
    
    <div class="flex items-center justify-between gap-4">
        <!-- Home Team -->
        <div class="flex flex-col items-center flex-1">
            <img src="{{ Str::startsWith($match->home_team_logo, 'http') ? $match->home_team_logo : asset('storage/' . $match->home_team_logo) }}" 
                 class="h-12 w-12 object-contain mb-2 drop-shadow-lg"
                 onerror="this.src='https://cdn-icons-png.flaticon.com/512/53/53254.png'">
            <span class="text-[11px] font-bold text-white text-center line-clamp-1">{{ $match->{'home_team_name_'.app()->getLocale()} ?: $match->home_team_name_en }}</span>
        </div>

        <!-- Score/Status -->
        <div class="flex flex-col items-center">
            <div class="text-3xl font-black text-amber-500 flex gap-2">
                <span>{{ $match->home_score ?? 0 }}</span>
                <span class="text-gray-600 opacity-30">-</span>
                <span>{{ $match->away_score ?? 0 }}</span>
            </div>
            @if($match->status == 'FT')
                <span class="text-[9px] text-gray-500 font-bold mt-2 bg-white/5 px-2 py-0.5 rounded">FT</span>
            @elseif($match->status == 'NS')
                <span class="text-[10px] text-blue-400 font-bold mt-2">{{ \Carbon\Carbon::parse($match->match_date)->format('H:i') }}</span>
            @else
                <span class="text-[9px] text-red-500 font-black mt-2 animate-pulse">{{ $match->status }}'</span>
            @endif
        </div>

        <!-- Away Team -->
        <div class="flex flex-col items-center flex-1">
            <img src="{{ Str::startsWith($match->away_team_logo, 'http') ? $match->away_team_logo : asset('storage/' . $match->away_team_logo) }}" 
                 class="h-12 w-12 object-contain mb-2 drop-shadow-lg"
                 onerror="this.src='https://cdn-icons-png.flaticon.com/512/53/53254.png'">
            <span class="text-[11px] font-bold text-white text-center line-clamp-1">{{ $match->{'away_team_name_'.app()->getLocale()} ?: $match->away_team_name_en }}</span>
        </div>
    </div>
</a>