<?php $__env->startSection('title', ($player->{'name_'.app()->getLocale()} ?: $player->name_en) . ' - ' . __('messages.player_profile')); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto py-8">
    <div class="mb-8">
        <a href="<?php echo e(route('players.index')); ?>" class="inline-flex items-center gap-2 text-slate-400 hover:text-white transition font-bold">
            <i class="fas fa-chevron-<?php echo e(app()->getLocale() == 'ar' ? 'right' : 'left'); ?>"></i>
            <span><?php echo e(__('messages.players')); ?></span>
        </a>
    </div>

    <div class="bg-slate-900/40 border border-white/5 rounded-[3rem] overflow-hidden shadow-2xl backdrop-blur-md">
        <!-- Profile Header -->
        <div class="relative h-48 bg-gradient-to-r from-blue-600 to-emerald-600">
            <div class="absolute inset-0 bg-black/20"></div>
        </div>
        
        <div class="px-12 pb-12 relative">
            <div class="flex flex-col md:flex-row items-end gap-8 -mt-24 mb-12">
                <div class="relative group">
                    <img src="<?php echo e(Str::startsWith($player->photo, 'http') ? $player->photo : asset('storage/' . $player->photo)); ?>" 
                         class="w-48 h-48 rounded-[2.5rem] object-cover border-8 border-[#020617] shadow-2xl relative z-10"
                         onerror="this.src='https://cdn-icons-png.flaticon.com/512/53/53254.png'">
                    <div class="absolute inset-0 bg-blue-500 rounded-[2.5rem] blur-2xl opacity-20 group-hover:opacity-40 transition"></div>
                </div>
                
                <div class="flex-1 text-center md:text-right mb-4">
                    <h1 class="text-4xl font-black text-white mb-2"><?php echo e($player->{'name_'.app()->getLocale()} ?: $player->name_en); ?></h1>
                    <div class="flex flex-wrap justify-center md:justify-start gap-3">
                        <span class="px-4 py-1.5 rounded-full text-xs font-black bg-blue-500 text-white shadow-lg shadow-blue-500/20 uppercase">
                            <?php echo e($player->position); ?>

                        </span>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($player->team): ?>
                        <span class="px-4 py-1.5 rounded-full text-xs font-black bg-white/10 text-white border border-white/10 flex items-center gap-2">
                            <img src="<?php echo e(Str::startsWith($player->team->logo, 'http') ? $player->team->logo : asset('storage/' . $player->team->logo)); ?>" class="h-4 w-4">
                            <?php echo e($player->team->{'name_'.app()->getLocale()} ?: $player->team->name_en); ?>

                        </span>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <!-- Info Sidebar -->
                <div class="md:col-span-1 space-y-6">
                    <div class="bg-white/5 rounded-3xl p-6 border border-white/5">
                        <h3 class="text-[10px] font-black text-slate-500 uppercase tracking-widest mb-4"><?php echo e(__('messages.general')); ?></h3>
                        <div class="space-y-4">
                            <div>
                                <span class="block text-xs text-slate-500 mb-1">ID</span>
                                <span class="font-bold">#<?php echo e($player->api_player_id); ?></span>
                            </div>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($player->team): ?>
                            <div>
                                <span class="block text-xs text-slate-500 mb-1"><?php echo e(__('messages.team')); ?></span>
                                <a href="<?php echo e(url('/team/' . $player->team->id)); ?>" class="font-bold text-blue-400 hover:underline">
                                    <?php echo e($player->team->{'name_'.app()->getLocale()} ?: $player->team->name_en); ?>

                                </a>
                            </div>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    </div>

                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($player->stats_json)): ?>
                    <div class="bg-white/5 rounded-3xl p-6 border border-white/5">
                        <h3 class="text-[10px] font-black text-slate-500 uppercase tracking-widest mb-4"><?php echo e(__('messages.statistics')); ?></h3>
                        <?php
                            $totalApp = 0; $totalGoals = 0; $totalAssists = 0; $totalYellow = 0; $totalRed = 0;
                            foreach($player->stats_json as $stat) {
                                $totalApp += $stat['games']['appearences'] ?? 0;
                                $totalGoals += $stat['goals']['total'] ?? 0;
                                $totalAssists += $stat['goals']['assists'] ?? 0;
                                $totalYellow += $stat['cards']['yellow'] ?? 0;
                                $totalRed += $stat['cards']['red'] ?? 0;
                            }
                        ?>
                        <div class="grid grid-cols-2 gap-4">
                            <div class="bg-black/20 p-3 rounded-2xl text-center">
                                <span class="block text-[10px] text-slate-500 uppercase"><?php echo e(__('messages.appearences')); ?></span>
                                <span class="text-xl font-black text-white"><?php echo e($totalApp); ?></span>
                            </div>
                            <div class="bg-black/20 p-3 rounded-2xl text-center">
                                <span class="block text-[10px] text-slate-500 uppercase"><?php echo e(__('messages.goals')); ?></span>
                                <span class="text-xl font-black text-emerald-400"><?php echo e($totalGoals); ?></span>
                            </div>
                            <div class="bg-black/20 p-3 rounded-2xl text-center">
                                <span class="block text-[10px] text-slate-500 uppercase"><?php echo e(__('messages.assists')); ?></span>
                                <span class="text-xl font-black text-blue-400"><?php echo e($totalAssists); ?></span>
                            </div>
                            <div class="bg-black/20 p-3 rounded-2xl text-center">
                                <div class="flex justify-center gap-2">
                                    <div class="flex flex-col">
                                        <span class="block text-[10px] text-slate-500 uppercase">Y/R</span>
                                        <span class="text-sm font-black text-white">
                                            <span class="text-yellow-400"><?php echo e($totalYellow); ?></span> / <span class="text-red-500"><?php echo e($totalRed); ?></span>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>

                <!-- Description / Content -->
                <div class="md:col-span-2">
                    <div class="bg-white/5 rounded-3xl p-8 border border-white/5 h-full">
                        <h3 class="text-[10px] font-black text-slate-500 uppercase tracking-widest mb-6"><?php echo e(__('messages.about_us')); ?></h3>
                        <div class="text-slate-300 leading-relaxed">
                            <?php echo $player->{'description_'.app()->getLocale()} ?: $player->description_en ?: '<p class="text-slate-500 italic">No additional information available for this player.</p>'; ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\bsports\resources\views/football/player_profile.blade.php ENDPATH**/ ?>