

<?php $__env->startSection('title', __('messages.players')); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto py-8">
    <div class="flex justify-between items-center mb-12">
        <h1 class="text-4xl font-black bg-gradient-to-r from-blue-400 to-emerald-400 bg-clip-text text-transparent">
            <?php echo e(__('messages.players')); ?>

        </h1>
    </div>

    <div class="bg-slate-900/40 border border-white/5 rounded-[2rem] overflow-hidden shadow-2xl backdrop-blur-md">
        <div class="overflow-x-auto">
            <table class="w-full text-right rtl:text-right ltr:text-left">
                <thead>
                    <tr class="bg-white/5 text-slate-400 uppercase text-[10px] font-black tracking-widest border-b border-white/5">
                        <th class="px-8 py-6"><?php echo e(__('messages.players')); ?></th>
                        <th class="px-8 py-6"><?php echo e(__('messages.position')); ?></th>
                        <th class="px-8 py-6"><?php echo e(__('messages.team')); ?></th>
                        <th class="px-8 py-6 text-center"><?php echo e(__('messages.actions')); ?></th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $players; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $player): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="hover:bg-white/5 transition group">
                        <td class="px-8 py-4">
                            <div class="flex items-center gap-4">
                                <img src="<?php echo e(Str::startsWith($player->photo, 'http') ? $player->photo : asset('storage/' . $player->photo)); ?>" 
                                     class="h-12 w-12 rounded-2xl object-cover shadow-xl border border-white/10"
                                     onerror="this.src='https://cdn-icons-png.flaticon.com/512/53/53254.png'">
                                <span class="font-bold text-white group-hover:text-blue-400 transition"><?php echo e($player->{'name_'.app()->getLocale()} ?: $player->name_en); ?></span>
                            </div>
                        </td>
                        <td class="px-8 py-4">
                            <span class="px-4 py-1.5 rounded-full text-[10px] font-black bg-blue-500/10 text-blue-400 border border-blue-500/20 uppercase">
                                <?php echo e($player->position); ?>

                            </span>
                        </td>
                        <td class="px-8 py-4">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($player->team): ?>
                            <div class="flex items-center gap-3">
                                <img src="<?php echo e(Str::startsWith($player->team->logo, 'http') ? $player->team->logo : asset('storage/' . $player->team->logo)); ?>" 
                                     class="h-6 w-6 object-contain">
                                <span class="text-sm font-bold text-slate-300"><?php echo e($player->team->{'name_'.app()->getLocale()} ?: $player->team->name_en); ?></span>
                            </div>
                            <?php else: ?>
                                <span class="text-slate-500 text-xs">N/A</span>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </td>
                        <td class="px-8 py-4 text-center">
                            <a href="<?php echo e(route('players.show', $player->id)); ?>" class="inline-flex items-center justify-center w-10 h-10 rounded-xl bg-slate-800 hover:bg-blue-600 text-white transition shadow-lg">
                                <i class="fas fa-eye text-sm"></i>
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </tbody>
            </table>
        </div>
        
        <div class="px-8 py-6 bg-black/20">
            <?php echo e($players->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\bsports\resources\views/football/players.blade.php ENDPATH**/ ?>