<?php

require 'vendor/autoload.php';
$app = require_once 'bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Services\FootballApiService;

$api = new FootballApiService;
$response = $api->getFixtures([
    'date' => '2026-01-30',
]);

echo 'Total fixtures for 2026-01-30: '.count($response)."\n";
if (count($response) > 0) {
    foreach (array_slice($response, 0, 5) as $f) {
        echo 'League: '.$f['league']['name'].' (ID: '.$f['league']['id'].') - Season: '.$f['league']['season'].' - Match: '.$f['teams']['home']['name'].' vs '.$f['teams']['away']['name']."\n";
    }
}
